<?php
// Set content type to JSON
header('Content-Type: application/json');

// Database connection parameters
$servername = "localhost";
$username = "root";
$password = "";
$database = "mirror_notifications";

// Check if the required parameters are set
if (isset($_GET['currentUserId'])) {
    // Create connection
    $conn = new mysqli($servername, $username, $password, $database);

    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Sanitize user input
    $currentUserId = mysqli_real_escape_string($conn, $_GET['currentUserId']);

    // Initialize response array
    $response = array();

    // SQL query to retrieve data from the app_notification table based on currentUserId
    $selectQuery = "SELECT * FROM `app_notification` WHERE `currentUserId`='$currentUserId'";
    $result = $conn->query($selectQuery);

    if ($result->num_rows > 0) {
        // Fetch data and add it to the response
        while ($row = $result->fetch_assoc()) {
            $notificationData = array(
                'notificationId' => $row['notificationId'],
                'currentUserId' => $row['currentUserId'],
                'receiverId' => $row['receiverId'],
                'boolean' => $row['boolean']
            );

            $response[] = $notificationData; // Directly add notification data to the response array
        }
    } else {
        // No data found for the provided currentUserId
        $response = array();
    }

    // Close the database connection
    $conn->close();

    // Send JSON response back to the client
    echo json_encode($response);
} else {
    echo json_encode(array("error" => "Missing parameters"));
}
?>
